import 'package:admin_desktop/presentation/components/header_item.dart';
import 'package:flutter/material.dart';
import 'package:auto_route/auto_route.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/application/providers.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/components/image/stories_image_picker.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import '../widgets/products_modal.dart';
import 'package:admin_desktop/domain/models/models.dart';
import '../../../../../catalogue/widgets/service_master/widgets/services_modal.dart';

class EditStoriesPage extends ConsumerStatefulWidget {
  const EditStoriesPage(this.onSave, {super.key});

  final Function() onSave;

  @override
  ConsumerState<EditStoriesPage> createState() => _EditStoriesPageState();
}

class _EditStoriesPageState extends ConsumerState<EditStoriesPage> {
  String _selectedType = 'product';
  ServiceData? service;
  List<String> types = ['product', 'service', 'shop'];

  @override
  void initState() {
    super.initState();
    final state = ref.read(editStoriesProvider);
    // Initialize type based on story
      _selectedType = state.story?.modelType ?? 'shop';
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(editStoriesProvider);
    final notifier = ref.read(editStoriesProvider.notifier);
    return KeyboardDisable(
      child: Stack(
        children: [
          Column(
            children: [
              Padding(
                padding: REdgeInsets.symmetric(horizontal: 16, vertical: 12),
                child: const HeaderItem(title: TrKeys.editStory),
              ),
              state.story == null
                  ? const Loading()
                  : Padding(
                      padding: REdgeInsets.symmetric(horizontal: 16),
                      child: Stack(
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              16.verticalSpace,
                              StoriesImagePicker(
                                listOfImages: state.images,
                                imageUrls: state.listOfUrls,
                                onImageChange: notifier.setImageFile,
                                onDelete: notifier.deleteImage,
                              ),
                              24.verticalSpace,
                              Row(
                                children: [
                                  Text(
                                    AppHelpers.getTranslation(
                                      TrKeys.storiesType,
                                    ),
                                    style: Style.interMedium(size: 16),
                                  ),
                                  16.horizontalSpace,
                                  DropdownButton<String>(
                                    value: _selectedType,
                                    items: [
                                      ...types.map(
                                        (e) => DropdownMenuItem(
                                          value: e,
                                          child: Text(
                                            AppHelpers.getTranslation(e),
                                          ),
                                        ),
                                      ),
                                    ],
                                    onChanged: (value) {
                                      setState(() {
                                        _selectedType = value!;
                                        state.textEditingController?.clear();
                                      });
                                    },
                                  ),
                                ],
                              ),
                              24.verticalSpace,
                              if (_selectedType == 'product')
                                OutlinedBorderTextField(
                                  readOnly: true,
                                  textController: state.textEditingController,
                                  label: AppHelpers.getTranslation(
                                    TrKeys.product,
                                  ),
                                  onTap: () {
                                    AppHelpers.showAlertDialog(
                                      context: context,
                                      child: SizedBox(
                                        height:
                                            MediaQuery.sizeOf(context).height /
                                            1.5,
                                        width:
                                            MediaQuery.sizeOf(context).width /
                                            3,
                                        child: ProductsModal(),
                                      ),
                                    );
                                  },
                                ),
                              if (_selectedType == 'service')
                                OutlinedBorderTextField(
                                  readOnly: true,
                                  label: AppHelpers.getTranslation(
                                    TrKeys.service,
                                  ),
                                  textController: state.textEditingController,
                                  onTap: () {
                                    AppHelpers.showAlertDialog(
                                      context: context,
                                      child: SizedBox(
                                        height:
                                            MediaQuery.sizeOf(context).height /
                                            1.5,
                                        width:
                                            MediaQuery.sizeOf(context).width /
                                            3,
                                        child: ServicesModal(
                                          onChange: (serviceData) {
                                            setState(() {
                                              service = serviceData;
                                              state
                                                      .textEditingController
                                                      ?.text =
                                                  serviceData
                                                      .translation
                                                      ?.title ??
                                                  '';
                                            });
                                          },
                                        ),
                                      ),
                                    );
                                  },
                                ),
                              if (_selectedType == 'shop')
                                const SizedBox.shrink(),
                              24.verticalSpace,
                            ],
                          ),
                        ],
                      ),
                    ),
            ],
          ),
          Positioned(
            bottom: 24.r,
            left: 16.r,
            right: 16.r,
            child: Padding(
              padding: REdgeInsets.symmetric(horizontal: 16),
              child: CustomButton(
                bgColor: Style.primary,
                textColor: Style.white,
                title: AppHelpers.getTranslation(TrKeys.save),
                isLoading: state.isLoading,
                onTap: () {
                  if (state.listOfUrls.isEmpty && state.images.isEmpty) {
                    AppHelpers.errorSnackBar(
                      context,
                      text: TrKeys.imageCantEmpty,
                    );
                    return;
                  }
                  int? id;
                  String? modelType;
                  if (_selectedType == 'product') {
                    id = state.selectProduct?.id;
                    modelType = 'product';
                  } else if (_selectedType == 'service') {
                    id = service?.id;
                    modelType = 'service';
                  } else {
                    id = null;
                    modelType = 'shop';
                  }
                  notifier.updateStories(
                    context,
                    id: id,
                    modelType: modelType,
                    updated: () {
                      ref
                          .read(storiesProvider.notifier)
                          .fetchStories(isRefresh: true);
                      context.maybePop();
                    },
                  );
                },
              ),
            ),
          ),
        ],
      ),
    );
  }
}
